/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.ClickCallbackGenerator;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Callback;
import com.roguewave.chart.core.v2_1.graphics.ClickablePolygon;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Line3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.StandardColors;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.ClickableSquareMarker;
import com.roguewave.chart.standard.v2_1.SquareMarkerDrawable;
import com.roguewave.chart.standard.v2_1.parts.Chart2DXYScale;
import com.roguewave.chart.standard.v2_1.parts.DefaultStyleCustomizer;
import com.roguewave.chart.standard.v2_1.parts.LineFit;
import com.roguewave.chart.standard.v2_1.parts.RescalerDrawable;
import java.awt.Color;
import java.awt.Font;

public class ScatterPlot
implements ChartBuilder {
    public static final boolean ROW = true;
    public static final boolean COLUMN = false;
    boolean dimension_;
    int[] xi_;
    int[] yi_;

    public ScatterPlot(boolean dimension, int[] xi, int[] yi) {
        this.dimension_ = dimension;
        this.xi_ = xi;
        this.yi_ = yi;
    }

    public boolean supports(int viewMode) {
        return viewMode == 0;
    }

    public ChartGraphics build(ChartProperties properties, DataModel data) {
        int columnInc;
        int column1;
        int column2;
        int rowInc;
        int row2;
        int row1;
        int dataLength;
        ChartGraphics chartGraphics = new ChartGraphics();
        ClickCallbackGenerator generator = properties.getClickCallbackGenerator();
        int markerSize = (Integer)properties.getProperty("MarkerSize", new Integer(4));
        StandardColors colorArray = new StandardColors();
        Customizer customizer = properties.get2DStyleCustomizer();
        Color[] colors = new Color[this.xi_.length];
        for (int i = 0; i < this.xi_.length; ++i) {
            colors[i] = properties.getColor(i, 0, colorArray.color(i), 0.0);
        }
        if (customizer instanceof DefaultStyleCustomizer) {
            DefaultStyleCustomizer cust = (DefaultStyleCustomizer)customizer;
            String[] items = new String[this.xi_.length];
            for (int i = 0; i < this.xi_.length; ++i) {
                items[i] = this.dimension_ ? String.valueOf(String.valueOf(data.getRowLabel(this.xi_[i])).concat(String.valueOf(" vs. "))).concat(String.valueOf(data.getRowLabel(this.yi_[i]))) : String.valueOf(String.valueOf(data.getColumnLabel(this.xi_[i])).concat(String.valueOf(" vs. "))).concat(String.valueOf(data.getColumnLabel(this.yi_[i])));
            }
            cust.setLegendItems(items, colors);
        }
        if (customizer != null) {
            chartGraphics.add2DDrawable(customizer.getDrawable(properties, data));
        }
        Boolean showLines = (Boolean)properties.getProperty("FittedLineShown", new Boolean(true));
        double rangeHigh = properties.getDataRangeHigh();
        double rangeLow = properties.getDataRangeLow();
        double range = rangeHigh - rangeLow;
        for (int index = 0; index < this.xi_.length; ++index) {
            if (this.dimension_) {
                dataLength = data.getColumnCount();
                row1 = this.xi_[index];
                row2 = this.yi_[index];
                rowInc = 0;
                column2 = 0;
                column1 = 0;
                columnInc = 1;
            } else {
                dataLength = data.getRowCount();
                row2 = 0;
                row1 = 0;
                rowInc = 1;
                column1 = this.xi_[index];
                column2 = this.yi_[index];
                columnInc = 0;
            }
            for (int i = 0; i < dataLength; ++i) {
                double x = data.getValue(row1, column1);
                double y = data.getValue(row2, column2);
            }
        }
        for (int index = 0; index < this.xi_.length; ++index) {
            if (this.dimension_) {
                dataLength = data.getColumnCount();
                row1 = this.xi_[index];
                row2 = this.yi_[index];
                rowInc = 0;
                column2 = 0;
                column1 = 0;
                columnInc = 1;
            } else {
                dataLength = data.getRowCount();
                row2 = 0;
                row1 = 0;
                rowInc = 1;
                column1 = this.xi_[index];
                column2 = this.yi_[index];
                columnInc = 0;
            }
            double[] x = new double[dataLength];
            double[] y = new double[dataLength];
            Callback[] callbacks = new Callback[dataLength];
            for (int i = 0; i < dataLength; ++i) {
                x[i] = data.getValue(row1, column1);
                y[i] = data.getValue(row2, column2);
                if (generator != null) {
                    int[] rowArr = new int[]{row1, row2};
                    int[] colArr = new int[]{column1, column2};
                    callbacks[i] = generator.generateCallback(data, rowArr, colArr);
                } else {
                    callbacks[i] = null;
                }
                row1 += rowInc;
                row2 += rowInc;
                column1 += columnInc;
                column2 += columnInc;
            }
            for (int i = 0; i < dataLength; ++i) {
                x[i] = (x[i] - rangeLow) / range - 0.5;
                y[i] = (y[i] - rangeLow) / range - 0.5;
            }
            Color markColor = colors[index];
            if (showLines.booleanValue()) {
                Point3D end2;
                LineFit lineFit = new LineFit(x, y);
                Point3D end1 = new Point3D(-0.5, lineFit.y(-0.5), 0.0);
                if (end1.Y() < -0.5) {
                    end1 = new Point3D(lineFit.x(-0.5), -0.5, 0.0);
                }
                if ((end2 = new Point3D(0.5, lineFit.y(0.5), 0.0)).Y() > 0.5) {
                    end2 = new Point3D(lineFit.x(0.5), 0.5, 0.0);
                }
                chartGraphics.add2DDrawable(new Line3DDrawable(new Line3D(end1, end2), markColor));
            }
            for (int i = 0; i < dataLength; ++i) {
                SquareMarkerDrawable marker = callbacks[i] == null ? new SquareMarkerDrawable(new Point3D(x[i], y[i], 0.0), markerSize, markColor) : new ClickableSquareMarker(new Point3D(x[i], y[i], 0.0), markerSize, markColor, callbacks[i]);
                chartGraphics.add2DDrawable(marker);
            }
        }
        double scaleIncrement = 10.0;
        double dataRange = properties.getDataRangeHigh() - properties.getDataRangeLow();
        while (dataRange / scaleIncrement > (double)10) {
            scaleIncrement *= (double)10;
        }
        while (dataRange / scaleIncrement < (double)5) {
            scaleIncrement /= (double)2;
        }
        scaleIncrement = properties.getProperty("ScaleIncrement", scaleIncrement);
        Chart2DXYScale scale = new Chart2DXYScale(properties, 1.0, 1.0, rangeLow, rangeLow, rangeHigh, rangeHigh, rangeLow, scaleIncrement, rangeLow, scaleIncrement, new Transform3D());
        scale.add2DTo(chartGraphics);
        double b = 0.5;
        Point3D[] bounds2D = new Point3D[]{new Point3D(-b, -b, 0.0), new Point3D(b, -b, 0.0), new Point3D(b, 0.5, 0.0), new Point3D(-b, 0.5, 0.0)};
        chartGraphics.setBounds2D(bounds2D);
        String[] scaleStrings = scale.getStrings();
        Font scaleFont = scale.getFont();
        chartGraphics.setRescaler(new RescalerDrawable(scaleStrings, scaleFont, bounds2D));
        return chartGraphics;
    }

    Drawable makePointMarker(double x, double y, Color color, Callback callback) {
        double halfSize = 0.01;
        Polygon3D marker = new Polygon3D(4, color);
        marker = new Polygon3D(4, color);
        marker.addPoint(new Point3D(x - halfSize, y - halfSize, 0.0));
        marker.addPoint(new Point3D(x - halfSize, y + halfSize, 0.0));
        marker.addPoint(new Point3D(x + halfSize, y + halfSize, 0.0));
        marker.addPoint(new Point3D(x + halfSize, y - halfSize, 0.0));
        if (callback != null) {
            return new ClickablePolygon(marker, callback);
        }
        return new Polygon3DDrawable(marker);
    }

    public boolean getAxis() {
        return this.dimension_;
    }

    public void setAxis(boolean axis) {
        if (this.dimension_ != axis) {
            this.dimension_ = axis;
            int[] xi = new int[]{0};
            int[] yi = new int[]{1};
            this.xi_ = xi;
            this.yi_ = yi;
        }
    }

    public void setIndices(int[] xi, int[] yi) {
        this.xi_ = xi;
        this.yi_ = yi;
    }
}

